<?PHP

/*-----------------------------------------------------------------------------------*/
/*	Modified JS loader for framework
/*-----------------------------------------------------------------------------------*/

function fbtp_tc_jsloader() {
	
	// Make sure we are not in the admin section
	if (!is_admin()) {
		
		// Load jQuery
		wp_enqueue_script('jquery');
		
		// Only include Facebook if enabled
		if( get_option('fbtpop-api-enabled') == 'true'){
			
			$check = get_option('fbtpop-api-locale');
			
			// Get the locale to use
			if( $check == '' || !isset( $check ) ){
				
				$fblocale = 'en_US';
				
			} else {
				
				$fblocale = get_option('fbtpop-api-locale');
				
			}
			
			wp_register_script('facebook', 'http://connect.facebook.net/'.$fblocale.'/all.js#xfbml=1'. false, '1.0', false);
			wp_enqueue_script('facebook');
			
		} // end api check
		
		// Include them
		wp_register_script('fbtp', FBTPOP_LOCATION.'/fb-like-pop.js', false, '3.3.0', true);
		wp_enqueue_script('fbtp');
		
		// Flush, register, enque Traficc Pop CSS
		$fbtp_theme = get_option('fbtpop-theme');
		$utheme = 'themes/'.$fbtp_theme.'/'.$fbtp_theme.'.css';
		wp_deregister_style('fbtpCSS');
		wp_register_style('fbtpCSS', FBTPOP_LOCATION.'/'.$utheme);
		wp_enqueue_style('fbtpCSS');
		
	}
	
}

/*-----------------------------------------------------------------------------------*/
/*	Modified FBTP function for framework
/*-----------------------------------------------------------------------------------*/

function FBTrafficPop_tc(){

	// Define current post
	global $post;
	
	// Get all of the options required for the popup
	$fbtp_onclick = get_option('fbtpop-onclick');
	$fbtp_title = esc_attr(get_option('fbtpop-title'));
	$fbtp_message = esc_textarea(fbtpop_cleanMsg(get_option('fbtpop-message')));
	$fbtp_url = get_option('fbtpop-url');
	$fbtp_countdown = get_option('fbtpop-countdown');
	$fbtp_wait = get_option('fbtpop-wait');
	$fbtp_close = get_option('fbtpop-close');
	$fbtp_enabled = get_option('fbtpop-enabled');
	$fbtp_opacity = get_option('fbtpop-opacity');
	$fbtp_advanced = get_option('fbtpop-advanced');
	$fbtp_pages = explode(',', get_option('fbtpop-pages'));
	$fbtp_selector = get_option('fbtpop-page-selector');
	$fbtp_showfaces = get_option('fbtpop-showfaces');
	$fbtp_colorscheme = get_option('fbtpop-scheme');
	$fbtp_lang = get_option('fbtpop-lang');
	$fbtp_delay = get_option('fbtpop-delay');
	$fbtp_theme = get_option('fbtpop-theme');
	$fbtp_share_on = get_option('fbtpop-share-on');
	$fbtp_share_title = get_option('fbtpop-share-title');
	$fbtp_share_message = get_option('fbtpop-share-message');
	$fbtp_share_label = get_option('fbtpop-share-label');
	$fbtp_app_id = get_option('fbtpop-app-id');	
	$fbtp_layout = 'standard';
	
	if( preg_match('/default\//', $fbtp_theme) ){
		$fbtp_layout = 'standard';
	} else if( preg_match('/big-button\//', $fbtp_theme) ){
		$fbtp_layout = 'box_count';
	}
	
	// Delay check
	if($fbtp_delay == '' || !isset($fbtp_delay)){
		
		// Default to zero
		$fbtp_delay == '0';
	
	}
			
	// Only continue if the pop-up option is enabled...
	if($fbtp_enabled != 3){
				
		// If only to include in pages
		if($fbtp_selector == 1){
			
			$switch = false;
			
			// Check if page is in the array
			if(in_array($post->ID, $fbtp_pages)){
			
				// set to true bc page is in selected array
				$switch = true;
				
			}
		
		// else check to exclude from pages
		} else if($fbtp_selector == 2){
			
			$switch = true;
			
			// disable if page is in array
			if(in_array($post->ID, $fbtp_pages)){
				
				// disable
				$switch = false;
				
			}
			
		} // end selector check
		
		// Check if homepage should display STP
		if(is_home() && $fbtp_enabled == 1){
			
			$switch = true;
			
		} else if(is_home() && $fbtp_enabled == 2){
			
			$switch = false;
			
		}
		
		// only show if switch is on
		if($switch == true){ ?>
							
			<script language="javascript">
					
				jQuery(document).ready(function(){		
						
					jQuery().facebookTrafficPop({
						'timeout':'<?PHP echo $fbtp_countdown; ?>', 
						'delay':'<?PHP echo $fbtp_delay; ?>',
						'title':'<?PHP echo $fbtp_title; ?>',
						'message':'<?PHP echo $fbtp_message; ?>',
						'url':'<?PHP echo $fbtp_url; ?>',
						'lang':'<?PHP echo $fbtp_lang; ?>',
						'wait':'<?PHP echo $fbtp_wait; ?>',
						'opacity':'<?PHP echo $fbtp_opacity; ?>',
						'advancedClose':<?PHP echo $fbtp_advanced; ?>,
						'closeable':<?PHP echo $fbtp_close; ?>,
						'showfaces':<?PHP echo $fbtp_showfaces; ?>,
						'layout':'<?PHP echo $fbtp_layout; ?>',
						'colorscheme':'<?PHP echo $fbtp_colorscheme; ?>',
						'onClick':'<?PHP echo $fbtp_onclick; ?>',
						'share_button':<?PHP echo $fbtp_share_on; ?>,
						'share_label':'<?PHP echo $fbtp_share_label; ?>',
						'share_title':'<?PHP echo $fbtp_share_title; ?>',
						'share_message':'<?PHP echo $fbtp_share_message; ?>',
						'app_id':'<?PHP echo $fbtp_app_id; ?>'
					});
						
				});
				
			</script>

	<?PHP
	
		} // End if switch enabled
		
	} // End if enabled
		
} // End main function

/*-----------------------------------------------------------------------------------*/
/*	Ajax save callback
/*-----------------------------------------------------------------------------------*/

add_action('wp_ajax_tc_framework_save', 'tc_framework_save');
function tc_framework_save() {

	check_ajax_referer('tc_framework_save', 'security');
	
        // Save the posted value in the database
		update_option('fbtpop-pages', $_POST['fbtpop-pages']);
		update_option('fbtpop-page-selector', $_POST['fbtpop-page-selector']);
		update_option('fbtpop-enabled', $_POST['fbtpop-enabled']);
		update_option('fbtpop-title', $_POST['fbtpop-title']);
		update_option('fbtpop-message', $_POST['fbtpop-message']);
		update_option('fbtpop-url', $_POST['fbtpop-url']);
		update_option('fbtpop-close', $_POST['fbtpop-close']);
		update_option('fbtpop-close-cookie', $_POST['fbtpop-close-cookie']);
		update_option('fbtpop-advanced', $_POST['fbtpop-advanced']);
		update_option('fbtpop-countdown', $_POST['fbtpop-countdown']);
		update_option('fbtpop-wait', $_POST['fbtpop-wait']);
		update_option('fbtpop-opacity', $_POST['fbtpop-opacity']);
		update_option('fbtpop-showfaces', $_POST['fbtpop-showfaces']);
		update_option('fbtpop-lang', $_POST['fbtpop-lang']);
		update_option('fbtpop-api-enabled', $_POST['fbtpop-api-enabled']);
		update_option('fbtpop-api-locale', $_POST['fbtpop-api-locale']);
		update_option('fbtpop-delay', $_POST['fbtpop-delay']);
		update_option('fbtpop-theme', $_POST['fbtpop-theme']);
		update_option('fbtpop-onclick', $_POST['fbtpop-onclick']);
		// Share
		update_option('fbtpop-share-on', $_POST['fbtpop-share-on']);
		update_option('fbtpop-share-url', $_POST['fbtpop-share-url']);
		update_option('fbtpop-share-title', $_POST['fbtpop-share-title']);
		update_option('fbtpop-share-message', $_POST['fbtpop-share-message']);
		update_option('fbtpop-share-label', $_POST['fbtpop-share-label']);
		update_option('fbtpop-app-id', $_POST['fbtpop-app-id']);
		
}

/*-----------------------------------------------------------------------------------*/
/*	New framework settings page
/*-----------------------------------------------------------------------------------*/

function fbtpop_tc_settings_page() {

?>

<script>
	
jQuery(document).ready(function(){

/*-----------------------------------------------------------------------------------*/
/*	Options Pages and Tabs
/*-----------------------------------------------------------------------------------*/
	  
	jQuery('.options_pages li').click(function(){
		
		var tab_page = 'div#' + jQuery(this).attr('id');
		var old_page = 'div#' + jQuery('.options_pages li.active').attr('id');
		
		// Change button class
		jQuery('.options_pages li.active').removeClass('active');
		jQuery(this).addClass('active');
				
		// Set active tab page
		jQuery(old_page).fadeOut('slow', function(){
			
			jQuery(tab_page).fadeIn('slow');
			
		});
		
	});
	
/*-----------------------------------------------------------------------------------*/
/*	Form Submit
/*-----------------------------------------------------------------------------------*/
	
	jQuery('form#plugin-options').submit(function(){
		
		// Update MCE
		tinyMCE.triggerSave();
		
		// Post Form
		var data = jQuery(this).serialize();
		jQuery.post(ajaxurl, data, function(response){
						
			if(response == 0){
				
				// Flash success message and shadow
				var success = jQuery('#success-save');
				var bg = jQuery("#message-bg");
				success.css("position","absolute");
				success.css("top", ((jQuery(window).height() - success.outerHeight()) / 2) + jQuery(window).scrollTop() + "px");
				success.css("left", ((jQuery(window).width() - success.outerWidth()) / 2) + jQuery(window).scrollLeft() + "px");
				bg.css({"height": jQuery(window).height()});
				bg.css({"opacity": .45});
				bg.fadeIn("slow", function(){
					success.fadeIn('slow', function(){
						success.delay(1500).fadeOut('fast', function(){
							bg.fadeOut('fast');
						});
					});
				});
								
			} else {
				
				//error out
				
			}
		
		});
				  
		return false;
	
	});	
	
/*-----------------------------------------------------------------------------------*/
/*	Finished
/*-----------------------------------------------------------------------------------*/
	
});

</script>




<div class="wrap">

    <div id="icon-options-general" class="icon32"><br/></div>
    <h2 class="tc-heading"><?PHP _e('Facebook Traffic Pop Pro', 'fbtpop'); ?> <span id="version">V3.3.0</span> <a href="<?PHP echo FBTPOP_LOCATION; ?>/documentation" target="_blank">&raquo; <?PHP _e('View Plugin Documentation', 'fbtpop'); ?></a></h2>

</div>

<div id="message-bg"></div>
<div id="success-save"></div>

<div id="tc_framework_wrap">

    <div id="content_wrap">
    
    	<form id="plugin-options" name="plugin-options" action="/">
        <?php settings_fields( 'fbtpop-settings-group' ); ?>
        <input type="hidden" name="action" value="tc_framework_save" />
        <input type="hidden" name="security" value="<?php echo wp_create_nonce('tc_framework_save'); ?>" />
        <input type="hidden" name="fbtpop-close" id="fbtpop-close" value="false" />
        <input type="hidden" name="fbtpop-close-cookie" id="fbtpop-close-cookie" value="false" />
        <input type="hidden" name="fbtpop-advanced" id="fbtpop-advanced" value="false" />
        <input type="hidden" name="fbtpop-share-on" id="fbtpop-share-on" value="false" />
        <input type="hidden" name="fbtpop-showfaces" id="fbtpop-showfaces" value="false" />

        	<div id="sub_header" class="info">
            
                <input type="submit" name="settingsBtn" id="settingsBtn" class="button-framework save-options" value="<?php _e('Save All Changes') ?>" />
                <span>Options Page</span>
                
            </div>
            
            <div id="content">
            
            	<div id="options_content">
                
                	<ul class="options_pages">
                    	<li id="general_options" class="active"><a href="#">General Settings</a><span></span></li>
                    	<li id="layout_options"><a href="#">Popup Settings</a><span></span></li>
                    	<li id="api_options"><a href="#">Facebook SDK Settings</a><span></span></li>
                    </ul>
                    
                    <div id="general_options" class="options_page">
                    
                    	<div class="option">
                        	<h3><?PHP _e('Enable Facebook Traffic Pop', 'fbtpop') ?></h3>
                            <div class="section">
                            	<div class="element"><select name="fbtpop-enabled" id="fbtpop-enabled" class="textfield">
                    <option value="1" <?PHP if(get_option('fbtpop-enabled') == '1'){echo 'selected="selected"';} ?>><?PHP _e('Enabled & Show on Homepage', 'fbtpop') ?></option>
                    <option value="2" <?PHP if(get_option('fbtpop-enabled') == '2'){echo 'selected="selected"';} ?>><?PHP _e('Enabled & Do Not Show on Homepage', 'fbtpop') ?></option>
                    <option value="3" <?PHP if(get_option('fbtpop-enabled') == '3'){echo 'selected="selected"';} ?>><?PHP _e('Disabled ( Off )', 'fbtpop') ?></option>
                				</select></div>
                                <div class="description"><?PHP _e('Enable or disable Facebook Traffic Pop and choose to show it on the homepage.', 'fbtpop') ?></div>
                            </div>
                        </div>

                    	<div class="option">
                        	<h3><?PHP _e('Exclude or Include Selected Pages', 'fbtpop') ?></h3>
                            <div class="section">
                            	<div class="element"><select name="fbtpop-page-selector" id="fbtpop-page-selector" class="textfield">
                    <option value="1" <?PHP if(get_option('fbtpop-page-selector') == '1'){echo 'selected="selected"';} ?>><?PHP _e('Only Show on Selected Pages', 'fbtpop') ?></option>
                    <option value="2" <?PHP if(get_option('fbtpop-page-selector') == '2'){echo 'selected="selected"';} ?>><?PHP _e('Show on All Pages But The Selected Pages', 'fbtpop') ?></option>
                				</select></div>
                                <div class="description"><?PHP _e('Choose how selected pages should be used.', 'fbtpop') ?></div>
                            </div>
                        </div>

                    	<div class="option">
                        	<h3><?PHP _e('Selected Pages', 'fbtpop') ?></h3>
                            <div class="section">
                            	<div class="element"><input name="fbtpop-pages" id="fbtpop-pages" class="textfield" value="<?php echo get_option('fbtpop-pages'); ?>" /></div>
                                <div class="description"><?PHP _e('Enter any page or post id seperated by commas. ex. 256, 162, 3, 45', 'fbtpop') ?></div>
                            </div>
                        </div>
                        
                    	<div class="option">
                        	<h3><?PHP _e('onClick Class', 'fbtpop') ?></h3>
                            <div class="section">
                            	<div class="element"><input class="textfield" name="fbtpop-onclick" type="text" id="fbtpop-onclick" value="<?php echo get_option('fbtpop-onclick'); ?>" /></div>
                                <div class="description"><?PHP _e('Enter the class to use with onClick. Classes with this element will launch the popup when clicked.', 'fbtpop') ?></div>
                            </div>
                        </div>

                    	<div class="option">
                        	<h3><?PHP _e('Countdown Length', 'fbtpop') ?></h3>
                            <div class="section">
                            	<div class="element"><input class="textfield" name="fbtpop-countdown" type="text" id="fbtpop-countdown" value="<?php echo get_option('fbtpop-countdown'); ?>" /></div>
                                <div class="description"><?PHP _e('Enter how long the popup should run for before closing itself. Default is 25', 'fbtpop') ?></div>
                            </div>
                        </div>

                    	<div class="option">
                        	<h3><?PHP _e('Popup Delay', 'fbtpop') ?></h3>
                            <div class="section">
                            	<div class="element"><input class="textfield" name="fbtpop-delay" type="text" id="fbtpop-delay" value="<?php echo get_option('fbtpop-delay'); ?>" /></div>
                                <div class="description"><?PHP _e('Enter the # of seconds to wait before the popup will show to users. Default is 0.', 'fbtpop') ?></div>
                            </div>
                        </div>
                        
                    	<div class="option">
                        	<h3><?PHP _e('Wait Timer', 'fbtpop') ?></h3>
                            <div class="section">
                            	<div class="element"><input class="textfield" name="fbtpop-wait" type="text" id="fbtpop-wait" value="<?php echo get_option('fbtpop-wait'); ?>" /></div>
                                <div class="description"><?PHP _e('Enter how long Facebook Traffic Pop should wait between showing in minuets. Enter 0 to show until user completes social action.', 'fbtpop') ?></div>
                            </div>
                        </div>
                                                
                    </div>            

                    <div id="layout_options" class="options_page hide">
                    

                    	<div class="option">
                        	<h3><?php _e('Popup Setup', 'fbtpop') ?></h3>
                            <div class="section">
                            	<div class="element">
                                    <div class="tc-radio-group">
										<p><?php _e('Traffic Pop Theme', 'fbtpop') ?></p>
                                        <select name="fbtpop-theme" id="fbtpop-theme" class="textfield">
											<?PHP fbtpop_theme_menu(); ?>
                                        </select>                                    
										<p><?php _e('Traffic Pop Locale', 'fbtpop') ?></p>
                                        <select class="textfield" name="fbtpop-lang" id="fbtpop-lang">
                                            <option value="en" <?PHP if(get_option('fbtpop-lang') == 'en'){echo 'selected="selected"';} ?>>EN</option>
                                            <option value="es" <?PHP if(get_option('fbtpop-lang') == 'es'){echo 'selected="selected"';} ?>>ES</option>
                                            <option value="de" <?PHP if(get_option('fbtpop-lang') == 'de'){echo 'selected="selected"';} ?>>DE</option>
                                            <option value="it" <?PHP if(get_option('fbtpop-lang') == 'it'){echo 'selected="selected"';} ?>>IT</option>
                                            <option value="fr" <?PHP if(get_option('fbtpop-lang') == 'fr'){echo 'selected="selected"';} ?>>FR</option>
                                        </select>
										<p><?php _e('Background Opacity', 'fbtpop') ?></p>
                                    	<input name="fbtpop-opacity" id="fbtpop-opacity" class="textfield" type="text" value="<?php echo get_option('fbtpop-opacity'); ?>" />                                        
                                    </div>
                                </div>
                                <div class="description"><?php _e('Here you can configure various things about the popup. Select the theme you would like to use, the language the popup should use, and set the background opacity for the shadow.', 'fbtpop') ?></div>
                            </div>
                        </div>  


                    	<div class="option">
                        	<h3><?php _e('Like Button Setup', 'fbtpop') ?></h3>
                            <div class="section">
                            	<div class="element">
                                    <div class="tc-radio-group">
                                        <p><label><input name="fbtpop-showfaces" type="checkbox" class="tc-checkbox" id="ffbtpop-showfaces" value="true" <?PHP if(get_option('fbtpop-showfaces') == 'true'){?>checked="checked"<?PHP } ?> /><?PHP _e('Enable Show Faces', 'fbtpop'); ?></label></p>
										<p><?php _e('Like Button URL', 'fbtpop') ?></p>
                                    	<input name="fbtpop-url" id="fbtpop-url" class="textfield" type="text" value="<?php echo get_option('fbtpop-url'); ?>" />
										<p><?php _e('Like Button Layout', 'fbtpop') ?></p>
                                      <select class="textfield" name="fbtpop-layout" id="fbtpop-layout">
                                            <option value="standard" <?PHP if(get_option('fbtpop-layout') == 'standard'){echo 'selected="selected"';} ?>><?php _e('Standard', 'fbtpop') ?></option>
                                            <option value="button_count" <?PHP if(get_option('fbtpop-layout') == 'button_count'){echo 'selected="selected"';} ?>><?php _e('Button Count', 'fbtpop') ?></option>
                                            <option value="box_count" <?PHP if(get_option('fbtpop-layout') == 'box_count'){echo 'selected="selected"';} ?>><?php _e('Box Count', 'fbtpop') ?></option>
                                        </select>
										<p><?php _e('Button Color Scheme', 'fbtpop') ?></p>
                                        <select class="textfield" name="fbtpop-scheme" id="fbtpop-scheme">
                                            <option value="light" <?PHP if(get_option('fbtpop-scheme') == 'light'){echo 'selected="selected"';} ?>>Light Theme</option>
                                            <option value="dark" <?PHP if(get_option('fbtpop-scheme') == 'dark'){echo 'selected="selected"';} ?>>Dark Theme</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="description"><?php _e('Configure the various options for the like button. For the Like URL you can also specify CURRENT and the like button will use the current page of your site.', 'fbtpop') ?></div>
                            </div>
                        </div>
                        
                        
                        
                        <div class="option">
                        	<h3><?php _e('Share Button Setup', 'fbtpop') ?></h3>
                            <div class="section">
                            	<div class="element">
                                    <div class="tc-radio-group">
                                        <p><label><input name="fbtpop-share-on" type="checkbox" class="tc-checkbox" id="ffbtpop-share-on" value="true" <?PHP if(get_option('fbtpop-share-on') == 'true'){?>checked="checked"<?PHP } ?> /><?PHP _e('Enable Share Button', 'fbtpop'); ?></label></p>
										<p><?php _e('Facebook App ID', 'fbtpop') ?></p>
                                    	<input name="fbtpop-app-id" id="fbtpop-app-id" class="textfield" type="text" value="<?php echo get_option('fbtpop-app-id'); ?>" />                                        
										<p><?php _e('Share Button URL', 'fbtpop') ?></p>
                                    	<input name="fbtpop-share-url" id="fbtpop-share-url" class="textfield" type="text" value="<?php echo get_option('fbtpop-share-url'); ?>" />                                        
										<p><?php _e('Share Button Label', 'fbtpop') ?></p>
                                    	<input name="fbtpop-share-label" id="fbtpop-share-label" class="textfield" type="text" value="<?php echo get_option('fbtpop-share-label'); ?>" />                                        
										<p><?php _e('Share Title Text', 'fbtpop') ?></p>
                                    	<input name="fbtpop-share-title" id="fbtpop-share-title" class="textfield" type="text" value="<?php echo get_option('fbtpop-share-title'); ?>" />                                        
										<p><?php _e('Share Message Text', 'fbtpop') ?></p>
                                    	<input name="fbtpop-share-message" id="fbtpop-share-message" class="textfield" type="text" value="<?php echo get_option('fbtpop-share-message'); ?>" />                                        
                                    </div>
                                </div>
                                <div class="description"><?php _e('Here you can set up the Share button including the URL to share, the pre-loaded title and message to be shared, and the text inside the Share button. Note that you need a valid Facebook APP ID to use the Share button, and it must be configured with URLs for your site in the App\'s settings on Facebook.', 'fbtpop') ?></div>
                            </div>
                        </div>
                        
                        
                    	<div class="option">
                        	<h3><?php _e('Close Options', 'fbtpop') ?></h3>
                            <div class="section">
                            	<div class="element">
                                    <div class="tc-radio-group">
                                        <p><label><input name="fbtpop-close" type="checkbox" class="tc-checkbox" id="fbtpop-close" value="true" <?PHP if(get_option('fbtpop-close') == 'true'){?>checked="checked"<?PHP } ?> /><?PHP _e('Enable Close Button', 'fbtpop'); ?></label></p>
                                        <p><label><input name="fbtpop-close-cookie" type="checkbox" class="tc-checkbox" id="fbtpop-close-cookie" value="true" <?PHP if(get_option('fbtpop-close-cookie') == 'true'){?>checked="checked"<?PHP } ?> /><?PHP _e('Enable Close Cookie', 'fbtpop'); ?></label></p>
                                        <p><label><input name="fbtpop-advanced" type="checkbox" class="tc-checkbox" id="fbtpop-advanced" value="true" <?PHP if(get_option('fbtpop-advanced') == 'true'){?>checked="checked"<?PHP } ?> /><?PHP _e('Enable Advanced Close', 'fbtpop'); ?></label></p>
                                    </div>
                                </div>
                                <div class="description"><?php _e('Here you can enable/disable the close button and choose to use the advanced close features. If enabled they allow you to close the popup using the escape key or clicking anywhere outside of the popup. If the close cookie is enabled, if the user clicks close the cookie will be set to keep the popup from showing anymore.', 'fbtpop') ?></div>
                            </div>
                        </div>  
                        

                    	<div class="option">
                        	<h3><?PHP _e('Popup Title', 'fbtpop'); ?></h3>
                            <div class="section">
                            	<div class="element"><input class="textfield" name="fbtpop-title" type="text" id="fbtpop-title" value="<?php echo stripslashes_deep(esc_attr(get_option('fbtpop-title'))); ?>" /></div>
                                <div class="description"><?PHP _e('Enter the title for your popup.', 'fbtpop'); ?></div>
                            </div>
                        </div>


                    	<div class="option">
                        	<h3><?PHP _e('Popup Message', 'fbtpop'); ?></h3>
                            <div class="section">
                            	<div class="tc-editor">
								<?PHP
                                
                                    wp_editor( stripslashes(get_option('fbtpop-message')), 'fbtpop-message-pro', array( 'textarea_name' => 'fbtpop-message', 'media_buttons' => true, 'tinymce' => array( 'theme_advanced_buttons1' => 'formatselect,forecolor,|,bold,italic,underline,|,bullist,numlist,blockquote,|,justifyleft,justifycenter,justifyright,justifyfull,|,link,unlink,|,spellchecker,wp_fullscreen,wp_adv' ) ) );
                                    
                                ?>
                                </div>
                                <div class="tc-editor-description"><?PHP _e('Enter the message you want to appear inside your popup.', 'fbtpop'); ?></div>
                            </div>
                        </div>
                        
                    </div>
                    
                    <div id="api_options" class="options_page hide">
                    
                    	<div class="option">
                        	<h3><?PHP _e('Enable Facebook JS SDK', 'fbtpop'); ?></h3>
                            <div class="section">
                            	<div class="element"><select name="fbtpop-api-enabled" id="fbtpop-api-enabled" class="textfield">
                    <option value="true" <?PHP if(get_option('fbtpop-api-enabled') == 'true'){echo 'selected="selected"';} ?>>Enabled</option>
                    <option value="false" <?PHP if(get_option('fbtpop-api-enabled') == 'false'){echo 'selected="selected"';} ?>>Disabled</option>
                				</select></div>
                                <div class="description"><?PHP _e('Note that the Facebook JS API SDK is required to run and should only be disabled if your site is loading multiple versions.', 'fbtpop'); ?></div>
                            </div>
                        </div>  
                        
                        
                    	<div class="option">
                        	<h3><?PHP _e('Facebook API Locale', 'fbtpop'); ?></h3>
                            <div class="section">
                            	<div class="element"><input class="textfield" name="fbtpop-api-locale" type="text" id="fbtpop-api-locale" value="<?php echo get_option('fbtpop-api-locale'); ?>" /></div>
                                <div class="description"><?PHP _e('Enter the locale to use (country code) with the Facebook JS API. This will control the locale used within Facebook plugins like the Like Button.', 'fbtpop'); ?></div>
                            </div>
                        </div>
                    
                    </div>        
            
            		<br class="clear" />
                    
            </div>
            
            <div class="info bottom">
            
                <input type="submit" name="settingsBtn" id="settingsBtn" class="button-framework save-options" value="<?php _e('Save All Changes') ?>" />
            
            </div>
            
        </form>
        
    </div>

</div>

<?php } ?>